var Calendar = function () {

  var base_url = window.location.origin + "/";

  return {
    //main function to initiate the module
    init: function () {
      Calendar.initCalendar();
    },

    initCalendar: function () {

      if (!jQuery().fullCalendar) {
        return;
      }

      var date = new Date();
      var d = date.getDate();
      var m = date.getMonth();
      var y = date.getFullYear();

      var h = {};

      if (Metronic.isRTL()) {
        if ($('#calendar').parents(".portlet").width() <= 720) {
          $('#calendar').addClass("mobile");
          h = {
            right: 'title, prev, next',
            center: '',
            left: 'agendaDay, agendaWeek, month, today'
          };
        } else {
          $('#calendar').removeClass("mobile");
          h = {
            right: 'title',
            center: '',
            left: 'agendaDay, agendaWeek, month, today, prev,next'
          };
        }
      } else {
        if ($('#calendar').parents(".portlet").width() <= 720) {
          $('#calendar').addClass("mobile");
          h = {
            left: 'title, prev, next',
            center: '',
            right: 'today,month,agendaWeek,agendaDay'
          };
        } else {
          $('#calendar').removeClass("mobile");
          h = {
            left: 'title',
            center: '',
            right: 'prev,next,today,month,agendaWeek,agendaDay'
          };
        }
      }

      var initDrag = function (el) {
        // create an Event Object (http://arshaw.com/fullcalendar/docs/event_data/Event_Object/)
        // it doesn't need to have a start or end
        var eventObject = {
          title: $.trim(el.text()) // use the element's text as the event title
        };
        // store the Event Object in the DOM element so we can get to it later
        el.data('eventObject', eventObject);
        // make the event draggable using jQuery UI
        el.draggable({
          zIndex: 999,
          revert: true, // will cause the event to go back to its
          revertDuration: 0 //  original position after the drag
        });
      };

      var addEvent = function (title) {
        title = title.length === 0 ? "Untitled Event" : title;
        var html = $('<div class="external-event label label-default">' + title + '</div>');
        jQuery('#event_box').append(html);
        initDrag(html);
      };

      $('#external-events div.external-event').each(function () {
        initDrag($(this));
      });

      $('#event_add').unbind('click').click(function () {
        var title = $('#event_title').val();
        addEvent(title);
      });

      var objeto1 = [];

      $.ajax({
        type: "POST",
        url: base_url + "Configuracoes/Agenda/getAgendaMensal",
        data: {
          csrf_token: $('#crsf_token').val()
        },
        dataType: 'json',
        success: function (data) {
          if (data.length > 0) {

            for (var i = 0; i < data.length; i++) {
              var titulo = data[i].TITULO;
              var descricao = data[i].DESCRICAO;
              var inicio = data[i].INICIO;
              var fim = data[i].FIM;
              var cor = data[i].COR;
              var id = data[i].ID_AGENDA;
              var oItem = {
                id: id,
                title: titulo,
                start: inicio,
                end: fim,
                description: descricao,
                backgroundColor: cor
              }
              objeto1.push(oItem);

            }
            $('#calendar').fullCalendar('destroy'); // destroy the calendar
            $('#calendar').fullCalendar({ //re-initialize the calendar
              header: h,
              defaultView: 'month', // change default view with available options from http://arshaw.com/fullcalendar/docs/views/Available_Views/
              slotMinutes: 15,
              editable: true,
              droppable: true, // this allows things to be dropped onto the calendar !!!
              drop: function (date, allDay) { // this function is called when something is dropped

                // retrieve the dropped element's stored Event Object
                var originalEventObject = $(this).data('eventObject');
                // we need to copy it, so that multiple events don't have a reference to the same object
                var copiedEventObject = $.extend({}, originalEventObject);

                // assign it the date that was reported
                copiedEventObject.start = date;
                copiedEventObject.allDay = allDay;
                copiedEventObject.className = $(this).attr("data-class");

                // render the event on the calendar
                // the last `true` argument determines if the event "sticks" (http://arshaw.com/fullcalendar/docs/event_rendering/renderEvent/)
                $('#calendar').fullCalendar('renderEvent', copiedEventObject, true);

                // is the "remove after drop" checkbox checked?
                if ($('#drop-remove').is(':checked')) {
                  // if so, remove the element from the "Draggable Events" list
                  $(this).remove();
                }
              },
              events: objeto1,
              editable: false,

              eventClick: function (event, jsEvent, view) {

                $.ajax({
                  type: "POST",
                  dataType: "json",
                  url: base_url + "Configuracoes/Agenda/getEvents",
                  data: {
                    'id': event.id,
                  },

                  success: function (data) {

                    if (data.length > 0) {
                      $('#data_inicio').val(data[0].datainicio);
                      $('#data_final').val(data[0].datafim);
                      $('#cor').val(data[0].COR);
                      $('#id_agenda').val(data[0].ID_AGENDA);
                      $('#titulo').val(data[0].TITULO);
                      $('#descricao').val(data[0].DESCRICAO);

                      $("#modal-lembrete").modal('show');

                      $("#Excluir_Lembrete").click(function () {
                        $("#modal-lembrete").modal('hide');
                        bootbox.confirm({
                          title: "Exclusão Lembrete",
                          message: "Deseja excluir o lembrete?",
                          buttons: {
                            confirm: {
                              label: 'Ok',
                              className: 'btn-danger'
                            }
                          },

                          callback: function (result) {
                            if (result) {
                              $.ajax({
                                type: "POST",
                                dataType: "json",
                                url: base_url + "Configuracoes/Agenda/deleteEvents",
                                data: {
                                  'id': event.id,
                                  csrf_token: $('#crsf_token').val()
                                },

                                success: function (data) {
                                  if (data.msg == 'success') {
                                    bootbox.confirm({
                                      title: "Exclusão",
                                      message: "Lembrete Excluido!",

                                      callback: function (result) {
                                        if (result) {
                                          window.location.reload();
                                        }
                                      }
                                    });
                                  } else {
                                    bootbox.confirm({
                                      title: "Exclusão",
                                      message: "Erro ao Excluir!!",

                                      callback: function (result) {
                                        if (result) {
                                          window.location.reload();
                                        }
                                      }
                                    });
                                  }
                                }
                              });
                            }
                          }
                        });

                      });

                    }
                  }
                });

              },
              dayClick: function (date, jsEvent, view) {

                $('#data_final').val('');
                $('#cor').val('#d9534f');
                $('#id_agenda').val('');
                $('#titulo').val('');
                $('#descricao').val('');
                //insere a data do dia no campo INICIO
                var data = date.format('DD/MM/YYYY').concat(' 00:00');
                $('#data_inicio').val(data);
                $("#modal-lembrete").modal('show');
              }
            });
          } else {
            $('#calendar').fullCalendar({ //re-initialize the calendar
              header: h,
              defaultView: 'month', // change default view with available options from http://arshaw.com/fullcalendar/docs/views/Available_Views/
              slotMinutes: 15,
              editable: true,
              droppable: true, // this allows things to be dropped onto the calendar !!!
              drop: function (date, allDay) { // this function is called when something is dropped

                // retrieve the dropped element's stored Event Object
                var originalEventObject = $(this).data('eventObject');
                // we need to copy it, so that multiple events don't have a reference to the same object
                var copiedEventObject = $.extend({}, originalEventObject);

                // assign it the date that was reported
                copiedEventObject.start = date;
                copiedEventObject.allDay = allDay;
                copiedEventObject.className = $(this).attr("data-class");

                // render the event on the calendar
                // the last `true` argument determines if the event "sticks" (http://arshaw.com/fullcalendar/docs/event_rendering/renderEvent/)
                $('#calendar').fullCalendar('renderEvent', copiedEventObject, true);

                // is the "remove after drop" checkbox checked?
                if ($('#drop-remove').is(':checked')) {
                  // if so, remove the element from the "Draggable Events" list
                  $(this).remove();
                }
              },
              events: objeto1,
              editable: false,


              dayClick: function (date, jsEvent, view) {

                $('#data_final').val('');
                $('#cor').val('#d9534f');
                $('#id_agenda').val('');
                $('#titulo').val('');
                $('#descricao').val('');
                //insere a data do dia no campo INICIO
                var data = date.format('DD/MM/YYYY').concat(' 00:00');
                $('#data_inicio').val(data);
                $("#modal-lembrete").modal('show');
              }
            });
          }
        }
      });
    }

  };

}();
