<?php namespace App\Controllers\Configuracoes;

 use App\Models\UsuarioModel;
 use CodeIgniter\Controller;
 use App\Libraries\Auth;
 
 class Permissoes extends Controller
 {

	public function __construct(){
        $this->session = \Config\Services::session();
        $this->usuario = $this->session->get('dadoslogin');
        if($this->usuario == null){
            return redirect()->to('/Login');
        }
        $this->usuariosModel = new UsuarioModel();
        $this->auth = new Auth();
        helper('complementos'); 
        
    }

	public function permissoesConsultar(){
        if($this->auth->CheckAuth(5)){
            $dados = array();
            $dados['usuarios'] = $this->usuariosModel->getUsuariosPermissao($this->usuario['ID_USUARIO']);
            $dados['perfis'] = $this->usuariosModel->getPerfisPermissao();
            echo view('Commons/header');
            echo view('Commons/navbartop');
            echo view('Commons/navbarleft', getBarMenu($this->usuario));
            echo view('Configuracoes/Permissoes/permissoes', $dados);
            echo view('Commons/footer');
        }else{
            return redirect()->to('/Acesso');
        }
    }

    public function permissoesInserir(){
        if($this->auth->CheckAuth(6)){
            $this->usuariosModel->setPermissoesUsuario($this->request->getPost('checkperm'), $this->request->getPost('permissoes_usuarios'));
            return redirect()->to('/Configuracoes/Permissoes/permissoesConsultar?tipo_msg=sucesso&msg=Ação realizada!');
        }
    }

    public function permissoesConsultarUsuario(){
        echo json_encode($this->usuariosModel->getPermissoesUsuario($this->request->getPost('usuario')));
    }
}